﻿//////////////////////////////////////////////
// EntityRenderLodSlot.h
// 
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Entity ;
	class EntityRenderInfoSlot ;
	class Mesh ;
	class Shader ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "../Bounds/BoundingBox.h"

// nkExport
#include <NilkinsExport/Exportable/Exportable.h>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT EntityRenderLodSlot final : public nkExport::Exportable
	{
		public :

			// Constructor, destructor
			EntityRenderLodSlot () noexcept ;
			EntityRenderLodSlot (Mesh* mesh, Shader* shader) noexcept ;
			virtual ~EntityRenderLodSlot () ;

			// Getters
			const BoundingBox& getBounds () const ;
			Mesh* getMesh () const ;
			Shader* getShader () const ;
			Shader* getRaytracingShader () const ;
			float getQualityMetric () const ;
			Shader* getActiveShader () const ;
			EntityRenderInfoSlot* getParentSlot () const ;
			Entity* getParentEntity () const ;

			// Setters
			void setMesh (Mesh* value) ;
			void setShader (Shader* value) ;
			void setRaytracingShader (Shader* value) ;
			void setQualityMetric (float value) ;
			void setDirtyNodeTransform (bool value) ;

			// Updates
			void meshBoundsUpdated () ;
			void meshLayoutUpdated () ;

			// Utilities
			bool isCompatibleWith (Shader* shade) const ;
			void updateActiveShader () ;

			// Import / Export
			virtual void exportClassToTree (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

		private :

			// Functions
			void _setParentSlot (EntityRenderInfoSlot* slot) ;
			void _setParentEntity (Entity* entity) ;

		private :

			// Attributes
			mutable BoundingBox _bounds ;
			Mesh* _mesh ;
			Shader* _shader ;
			Shader* _raytracingShader ;

			// Shader actually active (depends on mesh - shader compatibility)
			Shader* _activeShader ;

			// Tracked parents
			EntityRenderInfoSlot* _parentSlot ;
			Entity* _parentEntity ;

			float _qualityMetric ;

			mutable bool _dirtyNodeTransform ;
			bool _autoShader ;
			bool _autoRaytracingShader ;

		private :

			friend class EntityRenderInfoSlot ;
	} ;
}